function [C, Ceq, GC, GCeq] = LWM_nlcon(x, Ft)
% Nonlinear constraints for the optimization.
%==========================================================================================
% The function computes nonlinear constraints for the local optimization
% of the LWM parameters
%
%INPUT:
%        x             : 3M-by-1 vector of parameter estimates of the format:
%       [w^(1), ... , w^(M), F^(1), ... , F^(M), sigma^(1), sigma^(2), ... , sigma^(M)]
%        Ft            : spot futures price
%
%OUTPUT:
%        C             : value of the nonlinear inequality constraint
%        Ceq           : value of the nonlinear equality constraint
%        GC            : analytical gradient of the nonlinear inequality
%                        constraint
%        GCeq          : analytical gradient of the nonlinear equality
%                        constraint
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 



M = floor(length(x)/3); % number of mixtures
w_vec = x(1:M);
f_vec = x(M+1:2*M);
C=[];
GC=[];

% Ceq and GCeq
Ceq = w_vec'*f_vec-Ft ; GCeq = [f_vec;w_vec;zeros(M,1)];
end